/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import dan200.computercraft.client.model.LecternPocketModel;
import dan200.computercraft.client.model.LecternPrintoutModel;
import dan200.computercraft.client.pocket.ClientPocketComputers;
import dan200.computercraft.client.pocket.PocketComputerData;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.lectern.CustomLecternBlockEntity;
import dan200.computercraft.shared.media.items.PrintoutData;
import dan200.computercraft.shared.media.items.PrintoutItem;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3715;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_824;
import net.minecraft.class_827;
import net.minecraft.class_9282;
import net.minecraft.class_9322;
import org.joml.Vector2f;

@Environment(value=EnvType.CLIENT)
public class CustomLecternRenderer
implements class_827<CustomLecternBlockEntity> {
    private static final int POCKET_TERMINAL_RENDER_DISTANCE = 32;
    private final class_824 berDispatcher;
    private final LecternPrintoutModel printoutModel;
    private final LecternPocketModel pocketModel;

    public CustomLecternRenderer(class_5614.class_5615 context) {
        this.berDispatcher = context.method_32139();
        this.printoutModel = new LecternPrintoutModel();
        this.pocketModel = new LecternPocketModel();
    }

    public static void applyLecternTransform(class_4587 poseStack, class_2680 state) {
        poseStack.method_46416(0.5f, 1.0625f, 0.5f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(-((class_2350)state.method_11654((class_2769)class_3715.field_16404)).method_10170().method_10144()));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(67.5f));
        poseStack.method_46416(0.0f, -0.125f, 0.0f);
    }

    public void render(CustomLecternBlockEntity lectern, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
        poseStack.method_22903();
        CustomLecternRenderer.applyLecternTransform(poseStack, lectern.method_11010());
        class_1799 item = lectern.getItem();
        if (item.method_7909() instanceof PrintoutItem) {
            class_4588 vertexConsumer = LecternPrintoutModel.MATERIAL.method_24145(buffer, class_1921::method_23572);
            if (item.method_31574((class_1792)ModRegistry.Items.PRINTED_BOOK.get())) {
                this.printoutModel.renderBook(poseStack, vertexConsumer, packedLight, packedOverlay);
            } else {
                this.printoutModel.renderPages(poseStack, vertexConsumer, packedLight, packedOverlay, PrintoutData.getOrEmpty((class_9322)item).pages());
            }
        } else {
            class_1792 vertexConsumer = item.method_7909();
            if (vertexConsumer instanceof PocketComputerItem) {
                PocketComputerItem pocket = (PocketComputerItem)vertexConsumer;
                PocketComputerData computer = ClientPocketComputers.get(item);
                this.pocketModel.render(poseStack, buffer, packedLight, packedOverlay, pocket.getFamily(), class_9282.method_57470((class_1799)item, (int)-1), class_5253.class_5254.method_57174((int)(computer == null || computer.getLightState() == -1 ? Colour.BLACK.getHex() : computer.getLightState())));
                CustomLecternRenderer.applyPocketComputerTerminalTransform(poseStack);
                NetworkedTerminal terminal = computer == null ? null : computer.getTerminal();
                FixedWidthFontRenderer.QuadEmitter quadEmitter = FixedWidthFontRenderer.toVertexConsumer(poseStack, buffer.getBuffer(RenderTypes.TERMINAL));
                if (terminal != null && class_243.method_24953((class_2382)lectern.method_11016()).method_24802((class_2374)this.berDispatcher.field_4344.method_19326(), 32.0)) {
                    CustomLecternRenderer.renderPocketTerminal(poseStack, quadEmitter, terminal);
                } else {
                    FixedWidthFontRenderer.drawEmptyTerminal(quadEmitter, 0.0f, 0.0f, 0.375f, 0.4375f);
                }
            }
        }
        poseStack.method_22909();
    }

    public static void applyPocketComputerTerminalTransform(class_4587 poseStack) {
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        poseStack.method_22904(-0.1875, 0.25, 0.0625);
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
    }

    public static Vector2f applyScaledPocketComputerTerminalTransform(class_4587 poseStack, Terminal terminal) {
        int width = terminal.getWidth() * 6;
        int height = terminal.getHeight() * 9;
        float scaleX = 0.375f / (float)(width + 4);
        float scaleY = 0.4375f / (float)(height + 4);
        float scale = Math.min(scaleX, scaleY);
        poseStack.method_22905(scale, scale, -1.0f);
        float marginX = (0.375f / scale - (float)width) / 2.0f;
        float marginY = (0.4375f / scale - (float)height) / 2.0f;
        poseStack.method_46416(marginX, marginY, 0.0f);
        return new Vector2f(marginX, marginY);
    }

    private static void renderPocketTerminal(class_4587 poseStack, FixedWidthFontRenderer.QuadEmitter quadEmitter, Terminal terminal) {
        Vector2f margin = CustomLecternRenderer.applyScaledPocketComputerTerminalTransform(poseStack, terminal);
        FixedWidthFontRenderer.drawTerminal(quadEmitter, 0.0f, 0.0f, terminal, margin.y(), margin.y(), margin.x(), margin.x());
    }
}

